/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Materials;
import java.util.ArrayList;
import java.util.List;
import mantle.items.abstracts.CraftingItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.library.util.IToolPart;
import vexatos.tgregworks.TGregworks;
import vexatos.tgregworks.reference.PartTypes;
import vexatos.tgregworks.util.TGregUtils;

public class ItemTGregPart
extends CraftingItem
implements IToolPart {
    private PartTypes type;
    public static ArrayList<String> toolMaterialNames = TGregworks.registry.toolMaterialNames;

    public ItemTGregPart(PartTypes p) {
        super(toolMaterialNames.toArray(new String[toolMaterialNames.size()]), ItemTGregPart.buildTextureNames(p), "parts/", "tinker", (CreativeTabs)TGregworks.tab);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.type = p;
    }

    public PartTypes getType() {
        return this.type;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        String matName = !data.hasKey("material") || Materials.get((String)data.getString("material")) == Materials._NULL ? StatCollector.translateToLocal((String)"tgregworks.materials.unknown") : Materials.get((String)data.getString((String)"material")).mLocalizedName;
        String name = StatCollector.translateToLocal((String)("tgregworks.toolpart." + this.type.getPartName().replace(" ", "_").toLowerCase()));
        matName = name.replaceAll("%%material", matName);
        if (stack.getItemDamage() == 0) {
            matName = matName + StatCollector.translateToLocal((String)"tgregworks.tool.deprecated");
        }
        return matName;
    }

    public String getUnlocalizedName(ItemStack stack) {
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        String matName = !data.hasKey("material") || Materials.get((String)data.getString("material")) == Materials._NULL ? "Unknown" : Materials.get((String)data.getString((String)"material")).mDefaultLocalName;
        return matName;
    }

    public String getUnlocalizedName() {
        return this.type.getPartName();
    }

    private static String[] buildTextureNames(PartTypes p) {
        String[] names = new String[]{p.getTextureName()};
        return names;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[1];
        for (int i = 0; i < this.icons.length; ++i) {
            if (this.textureNames[i].equals("")) continue;
            this.icons[i] = iconRegister.registerIcon(this.modTexPrefix + ":" + this.folder + this.textureNames[i]);
        }
    }

    public void getSubItems(Item b, CreativeTabs tab, List list) {
        for (Materials m : TGregworks.registry.toolMaterials) {
            ItemStack stack = new ItemStack(b, 1, TGregworks.registry.matIDs.get(m).intValue());
            NBTTagCompound data = TGregUtils.getTagCompound(stack);
            data.setString("material", m.getName());
            stack.setTagCompound(data);
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        if (!data.hasKey("material")) {
            return super.getColorFromItemStack(stack, pass);
        }
        int[] rgba = this.toIntArray(ItemTGregPart.getRGBa(stack));
        int colour = rgba[0] << 16 | rgba[1] << 8 | rgba[2];
        return colour;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        Integer matID;
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        if (!data.hasKey("material")) {
            return;
        }
        Materials m = Materials.get((String)data.getString("material"));
        if (m != null && (matID = TGregworks.registry.matIDs.get(m)) != null && matID.intValue() != stack.getItemDamage()) {
            stack.setItemDamage(matID.intValue());
        }
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List tooltip, boolean par4) {
        super.addInformation(stack, player, tooltip, par4);
        if (stack.getItemDamage() == 0) {
            tooltip.add(EnumChatFormatting.GRAY.toString() + EnumChatFormatting.ITALIC.toString() + "Put this into your inventory to update it.");
        }
    }

    private int[] toIntArray(short[] r) {
        int[] i = new int[r.length];
        for (int j = 0; j < r.length; ++j) {
            i[j] = r[j];
        }
        return i;
    }

    public static short[] getRGBa(ItemStack stack) {
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        if (!data.hasKey("material")) {
            return Materials._NULL.mRGBa;
        }
        Materials m = Materials.get((String)data.getString("material"));
        if (m == null || m == Materials._NULL) {
            return Materials._NULL.mRGBa;
        }
        for (int i = 0; i < m.mRGBa.length; i = (int)((byte)(i + 1))) {
            if (m.mRGBa[i] > 255) {
                m.mRGBa[i] = 255;
            }
            if (m.mRGBa[i] >= 0) continue;
            m.mRGBa[i] = 0;
        }
        return m.mRGBa;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconIndex(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public int getMaterialID(ItemStack stack) {
        return TGregUtils.getMaterialID(stack);
    }
}

