/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks.integration.recipe.tconstruct;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.util.IToolPart;
import tconstruct.weaponry.TinkerWeaponry;
import vexatos.tgregworks.item.ItemTGregPart;
import vexatos.tgregworks.reference.PartTypes;

public class TGregAlternateBoltRecipe
implements IRecipe {
    protected ItemStack outputPart;

    public boolean matches(InventoryCrafting inventoryCrafting, World world) {
        this.outputPart = null;
        ItemStack rod = null;
        ItemStack head = null;
        for (int i = 0; i < inventoryCrafting.getSizeInventory(); ++i) {
            ItemStack slot = inventoryCrafting.getStackInSlot(i);
            if (slot == null) continue;
            if (this.isEqualType(PartTypes.ArrowHead, slot.getItem())) {
                if (head != null) {
                    return false;
                }
                head = slot;
                continue;
            }
            if (this.isEqualType(PartTypes.ToolRod, slot.getItem())) {
                if (rod != null) {
                    return false;
                }
                rod = slot;
                continue;
            }
            return false;
        }
        if (rod == null || head == null) {
            return false;
        }
        int mat1 = ((IToolPart)rod.getItem()).getMaterialID(rod);
        int mat2 = ((IToolPart)head.getItem()).getMaterialID(head);
        this.outputPart = DualMaterialToolPart.createDualMaterial((Item)TinkerWeaponry.partBolt, (int)mat1, (int)mat2);
        return true;
    }

    protected boolean isEqualType(PartTypes part, Item input) {
        if (input instanceof ItemTGregPart) {
            return part == ((ItemTGregPart)input).getType();
        }
        return input == part.getCounterpart();
    }

    public ItemStack getCraftingResult(InventoryCrafting inventory) {
        return this.outputPart;
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack getRecipeOutput() {
        return this.outputPart;
    }

    static {
        RecipeSorter.register((String)"TGregworks:part", TGregAlternateBoltRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }
}

