/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks.util;

import gregtech.api.enums.Materials;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import vexatos.tgregworks.TGregworks;
import vexatos.tgregworks.reference.PartTypes;

public class TGregUtils {
    public static NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack.hasTagCompound()) {
            return stack.getTagCompound();
        }
        NBTTagCompound data = new NBTTagCompound();
        stack.setTagCompound(data);
        return data;
    }

    public static NBTTagCompound getCompoundTag(NBTTagCompound tag, String key) {
        if (tag.hasKey(key)) {
            return tag.getCompoundTag(key);
        }
        NBTTagCompound data = new NBTTagCompound();
        tag.setTag(key, (NBTBase)data);
        return data;
    }

    public static NBTTagCompound getCompoundTag(ItemStack stack, String key) {
        return TGregUtils.getCompoundTag(TGregUtils.getTagCompound(stack), key);
    }

    public static int getMaterialID(ItemStack stack) {
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        if (!data.hasKey("material")) {
            return -1;
        }
        Integer matID = TGregworks.registry.matIDs.get(Materials.get((String)data.getString("material")));
        return matID != null ? matID : 0;
    }

    @Nonnull
    public static ItemStack newItemStack(Materials m, PartTypes p, int amount) {
        ItemStack stack = new ItemStack((Item)TGregworks.registry.toolParts.get((Object)p), amount, TGregworks.registry.matIDs.get(m).intValue());
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        data.setString("material", m.getName());
        stack.setTagCompound(data);
        return stack;
    }
}

