/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks.integration.modifiers;

import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import vexatos.tgregworks.TGregworks;
import vexatos.tgregworks.integration.TGregRepairRegistry;

public class ModTGregRepair
extends ItemModifier {
    public ModTGregRepair() {
        super(new ItemStack[0], 0, "TGregRepair");
    }

    public boolean matches(ItemStack[] input, ItemStack tool) {
        return this.canModify(tool, input);
    }

    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        if (tags.getInteger("Damage") > 0) {
            int headID = tags.getInteger("Head");
            boolean areInputsValid = true;
            for (ItemStack curInput : input) {
                if (curInput == null || headID == PatternBuilder.instance.getPartID(curInput) || this.isValidRepairMaterial(curInput, headID)) continue;
                areInputsValid = false;
                break;
            }
            if (areInputsValid) {
                return this.calculateIfNecessary(tool, input, headID);
            }
        }
        return false;
    }

    private boolean calculateIfNecessary(ItemStack tool, ItemStack[] input, int materialID) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int damage = tags.getInteger("Damage");
        int numInputs = 0;
        int materialValue = 0;
        for (ItemStack curInput : input) {
            if (curInput == null) continue;
            int partValue = PatternBuilder.instance.getPartValue(curInput);
            materialValue += partValue != 0 ? partValue : this.getRepairAmount(curInput, materialID);
            ++numInputs;
        }
        if (numInputs == 0) {
            return false;
        }
        int totalRepairValue = this.calculateIncrease(tool, materialValue, numInputs);
        float averageRepairValue = totalRepairValue / numInputs;
        return numInputs == 1 || (float)(damage - totalRepairValue) >= -averageRepairValue;
    }

    private boolean isValidRepairMaterial(ItemStack input, int materialID) {
        Set repairMaterials = TGregworks.repair.repairMaterials.get((Object)TGregworks.registry.materialIDMap.get(materialID));
        for (TGregRepairRegistry.RepairMaterial mat : repairMaterials) {
            if (!mat.matches(input)) continue;
            return true;
        }
        return false;
    }

    private int getRepairAmount(ItemStack input, int materialID) {
        Set repairMaterials = TGregworks.repair.repairMaterials.get((Object)TGregworks.registry.materialIDMap.get(materialID));
        for (TGregRepairRegistry.RepairMaterial mat : repairMaterials) {
            if (!mat.matches(input)) continue;
            return mat.value;
        }
        return 0;
    }

    private int calculateIncrease(ItemStack tool, int materialValue, int itemsUsed) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        int damage = tags.getInteger("Damage");
        int dur = tags.getInteger("BaseDurability");
        int increase = (int)((float)(50 * itemsUsed) + (float)dur * 0.4f * (float)materialValue);
        int modifiers = tags.getInteger("Modifiers");
        float mods = 1.0f;
        if (modifiers == 2) {
            mods = 0.9f;
        } else if (modifiers == 1) {
            mods = 0.8f;
        } else if (modifiers == 0) {
            mods = 0.7f;
        }
        increase = (int)((float)increase * mods);
        int repair = tags.getInteger("RepairCount");
        float repairCount = (float)(100 - repair) / 100.0f;
        if (repairCount < 0.5f) {
            repairCount = 0.5f;
        }
        increase = (int)((float)increase * repairCount);
        increase = (int)((float)increase / ((ToolCore)tool.getItem()).getRepairCost());
        return increase;
    }

    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.getTagCompound().getCompoundTag("InfiTool");
        tags.setBoolean("Broken", false);
        int damage = tags.getInteger("Damage");
        int headID = tags.getInteger("Head");
        int dur = tags.getInteger("BaseDurability");
        int itemsUsed = 0;
        int materialValue = 0;
        for (ItemStack curInput : input) {
            if (curInput == null) continue;
            int partValue = PatternBuilder.instance.getPartValue(curInput);
            materialValue += partValue != 0 ? partValue : this.getRepairAmount(curInput, headID);
            ++itemsUsed;
        }
        int increase = this.calculateIncrease(tool, materialValue, itemsUsed);
        int repair = tags.getInteger("RepairCount");
        tags.setInteger("RepairCount", repair += itemsUsed);
        if ((damage -= increase) < 0) {
            damage = 0;
        }
        tags.setInteger("Damage", damage);
        AbilityHelper.damageTool((ItemStack)tool, (int)0, null, (boolean)true);
    }

    public void addMatchingEffect(ItemStack tool) {
    }

    public boolean validType(IModifyable input) {
        return input.getModifyType().equals("Tool");
    }
}

