/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks.integration;

import com.google.common.collect.HashMultimap;
import gregtech.api.enums.Materials;
import gregtech.api.util.GTOreDictUnificator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import vexatos.tgregworks.TGregworks;
import vexatos.tgregworks.reference.PartTypes;
import vexatos.tgregworks.util.TGregUtils;

public class TGregRepairRegistry {
    public final HashMultimap<Materials, RepairMaterial> repairMaterials = HashMultimap.create();

    public void registerShardRepairMaterial(Materials m, int value) {
        this.repairMaterials.put((Object)m, (Object)new ShardRepairMaterial(m, value));
    }

    public void registerOreDictRepairMaterial(Materials m, String tag, int value) {
        this.repairMaterials.put((Object)m, (Object)new OreDictRepairMaterial(tag, value));
    }

    private static class OreDictRepairMaterial
    extends RepairMaterial {
        private final String tag;

        public OreDictRepairMaterial(String tag, int value) {
            super(value);
            this.tag = tag;
        }

        @Override
        public boolean matches(ItemStack input) {
            return GTOreDictUnificator.isItemStackInstanceOf((ItemStack)input, (Object)this.tag);
        }
    }

    public static class ShardRepairMaterial
    extends RepairMaterial {
        public final Materials m;

        public ShardRepairMaterial(Materials m, int value) {
            super(value);
            this.m = m;
        }

        @Override
        public boolean matches(ItemStack input) {
            if (input.getItem() == TGregworks.registry.toolParts.get((Object)PartTypes.Chunk)) {
                NBTTagCompound data = TGregUtils.getTagCompound(input);
                if (!data.hasKey("material")) {
                    return false;
                }
                Materials material = Materials.get((String)data.getString("material"));
                if (material != null && material == this.m) {
                    return true;
                }
            }
            return false;
        }
    }

    public static abstract class RepairMaterial {
        public final int value;

        public RepairMaterial(int value) {
            this.value = value;
        }

        public abstract boolean matches(ItemStack var1);
    }
}

