/*
 * Decompiled with CFR 0.152.
 */
package vexatos.tgregworks;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tconstruct.TConstruct;
import tconstruct.library.TConstructCreativeTab;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.modifiers.tools.ModToolRepair;
import vexatos.tgregworks.integration.TGregRecipeRegistry;
import vexatos.tgregworks.integration.TGregRegistry;
import vexatos.tgregworks.integration.TGregRepairRegistry;
import vexatos.tgregworks.integration.iguanatweakstconstruct.IntegrationITT;
import vexatos.tgregworks.integration.modifiers.ModTGregRepair;
import vexatos.tgregworks.integration.smeltery.CastLegacy;
import vexatos.tgregworks.integration.tictooltips.IntegrationTiCTooltips;
import vexatos.tgregworks.item.ShardPattern;
import vexatos.tgregworks.proxy.CommonProxy;
import vexatos.tgregworks.reference.Config;
import vexatos.tgregworks.reference.PartTypes;
import vexatos.tgregworks.util.TGregUtils;

@Mod(modid="TGregworks", name="Tinkers' Gregworks", version="1.7.10-GTNH-1.0.29", dependencies="required-after:TConstruct@[1.7.10-1.8.6b.build977,);required-after:gregtech@[MC1710];before:TiCTooltips@[1.2.4,)")
public class TGregworks {
    public static Logger log = LogManager.getLogger((String)"TGregworks");
    public static Configuration config;
    @Mod.Instance(value="TGregworks")
    public static TGregworks instance;
    @SidedProxy(clientSide="vexatos.tgregworks.proxy.ClientProxy", serverSide="vexatos.tgregworks.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static TGregRegistry registry;
    public static TGregRecipeRegistry recipes;
    public static TGregRepairRegistry repair;
    public static ShardPattern shardCast;
    public static IntegrationTiCTooltips ticTooltips;
    public static IntegrationITT iguanatweakstconstruct;
    public static TConstructCreativeTab tab;

    public TGregworks() {
        if (Loader.isModLoaded((String)"TConstruct")) {
            log.info("TConstruct detected, initializing Intergalactical integration...");
        }
        if (GregTechAPI.VERSION < 509) {
            throw new RuntimeException("Your GregTech version is too old for this edition of the mod! It only works with GregTech 5 Unofficial. Please use the main version of TGregworks or switch to GT5U.");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        registry = new TGregRegistry();
        registry.registerItems();
        registry.registerToolParts();
        registry.registerModifiers();
        recipes = new TGregRecipeRegistry();
        repair = new TGregRepairRegistry();
        config.setCategoryComment("global", "Values between 0.0 and 10000.0 are allowed. Will be directly multiplied with the internally calculated value. Applies to all materials.");
        config.setCategoryComment(Config.onMaterial("durability"), "Values between 0.0 and 10000.0 are allowed. Will be directly multiplied with the internally calculated value.");
        config.setCategoryComment(Config.onMaterial("miningspeed"), "Values between 0.0 and 10000.0 are allowed. Will be directly multiplied with the internally calculated value.");
        config.setCategoryComment(Config.onMaterial("attack"), "Values between 0.0 and 10000.0 are allowed. Will be directly multiplied with the internally calculated value.");
        config.setCategoryComment(Config.onMaterial("handlemodifier"), "Values between 0.0 and 10000.0 are allowed. Will be directly multiplied with the internally calculated value.");
        config.setCategoryComment(Config.onMaterial("material-id"), "Values between 0 and 100000 are allowed. The ID of each individual material. Setting an ID to 0 will regenerate it. When changing materialIDRangeStart, you might want to delete this category so the tool IDs can be regenerated.");
        config.setCategoryComment("materials.stoneboundlevel", "Values between -3 and 3 are allowed. Positive Values give the Stonebound effect, negative values give Jagged. Keep in mind that neither 'Stonebound' nor 'Jagged' will actually appear on the tool's item tooltip, due to technical limitations.");
        config.setCategoryComment("materials.reinforcedlevel", "Values between 0 and 3 are allowed. Gives the according level of Reinforced.");
        config.setCategoryComment(Config.onMaterial("bowdrawspeed"), "Values between 0.0 and 10000.0 are allowed. Will be directly multiplied with the internally calculated value.");
        config.setCategoryComment(Config.onMaterial("bowflightspeed"), "Values between 0.0 and 10000.0 are allowed. Will be directly multiplied with the internally calculated value.");
        config.setCategoryComment(Config.onMaterial("arrowmass"), "Values between 0.0 and 10000.0 are allowed. Will be directly multiplied with the internally calculated value.");
        config.setCategoryComment(Config.onMaterial("arrowfragility"), "Values between 0.0 and 10000.0 are allowed. Determines the break chance of arrows.");
        shardCast = new ShardPattern((CreativeTabs)tab);
        shardCast.setCreativeTab((CreativeTabs)tab).setUnlocalizedName("tgregworks.shardcast").setTextureName("tgregworks:cast_shard").setMaxDamage(0).setHasSubtypes(false).setMaxStackSize(1);
        GameRegistry.registerItem((Item)shardCast, (String)"tgregworks.shardcast");
        if (!TConstruct.pulsar.isPulseLoaded("Tinkers' Smeltery")) {
            CastLegacy.preInit();
        }
        ItemStack stack = new ItemStack((Item)TGregworks.registry.toolParts.get((Object)PartTypes.LargeSwordBlade));
        NBTTagCompound data = TGregUtils.getTagCompound(stack);
        data.setString("material", Materials.Osmiridium.getName());
        stack.setTagCompound(data);
        tab.init(stack);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.addToolRenderMappings();
        registry.registerFluids();
        proxy.registerRenderers();
        if (Loader.isModLoaded((String)"IguanaTweaksTConstruct")) {
            iguanatweakstconstruct = new IntegrationITT();
            iguanatweakstconstruct.init();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        recipes.addRecipesForToolBuilder();
        recipes.addGregTechPartRecipes();
        recipes.registerCastRecipes();
        recipes.registerRepairMaterials();
        recipes.registerBoltRecipes();
        if (Loader.isModLoaded((String)"TiCTooltips")) {
            ticTooltips = new IntegrationTiCTooltips();
            ticTooltips.postInit();
        }
        ModifyBuilder.instance.itemModifiers.removeIf(im -> im.getClass().equals(ModToolRepair.class));
        if (Loader.isModLoaded((String)"IguanaTweaksTConstruct")) {
            iguanatweakstconstruct.postInit();
        } else {
            ModifyBuilder.registerModifier((ItemModifier)new ModTGregRepair());
        }
        config.save();
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent e) {
        CastLegacy.remap(e);
    }

    static {
        tab = new TConstructCreativeTab("tabTGregworks");
    }
}

